/*
 * Copyright (c) 2017 - 2018 , NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */



/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef _LCD_H_
#define _LCD_H_

/* Includes ------------------------------------------------------------------*/
#include <math.h>
#include <stdlib.h>
#include "stdint.h"


/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/

#define LCD_WIDTH    240
#define LCD_HEIGHT   320

/*+--------- X ------------> LCD_WIDTH 
  |
  Y         SCREEN
  |
  v
LCD_HEIGHT
*/


#define LCD_FONT_1206    12
#define LCD_FONT_1608    16

#define LCD_COLOR_WHITE          0xFFFF
#define LCD_COLOR_BLACK          0x0000     
#define LCD_COLOR_BLUE           0x001F  
#define LCD_COLOR_BRED           0XF81F
#define LCD_COLOR_GRED           0XFFE0
#define LCD_COLOR_GBLUE          0X07FF
#define LCD_COLOR_RED            0xF800
#define LCD_COLOR_MAGENTA        0xF81F
#define LCD_COLOR_GREEN          0x07E0
#define LCD_COLOR_CYAN           0x7FFF
#define LCD_COLOR_YELLOW         0xFFE0
#define LCD_COLOR_BROWN          0XBC40 
#define LCD_COLOR_BRRED          0XFC07 
#define LCD_COLOR_GRAY           0X8430 

#define LCD_CMD                0
#define LCD_DATA               1

/* Exported functions ------------------------------------------------------- */

extern void lcd_init(void);
extern void lcd_clear_screen(uint16_t hwColor);
extern void lcd_display_char(uint16_t hwXpos, //specify x position.
                         uint16_t hwYpos, //specify y position.
                         uint8_t chChr,   //a char is display.
                         uint8_t chSize,  //specify the size of the char
                         uint16_t hwColor); //specify the color of the char

#endif
/*-------------------------------END OF FILE-------------------------------*/

